#ifndef __SSystemInformation__
#define __SSystemInformation__

#include "../Basics/CString.hpp"

//	===========================================================================

using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Host
	{
		/**
		 * @struct SSystemInformation SSystemInformation.hpp
		 * @brief Structure for host info
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: SSystemInformation.hpp,v 1.4 2007/02/08 21:06:44 paul Exp $
		 */
		struct SSystemInformation
		{
			CString m_computerName;			/**< name of the computer */
			CString m_userName;				/**< name of the user */
			CString m_osVersion;			/**< string representation of the os */
			CString m_processorString;		/**< string representation of the processor */
			long m_major;					/**< os major version */
			long m_minor;					/**< os minor version */
			long m_build;					/**< os build */
			long m_cpuSpeed;				/**< cpu speed in hz */
			long m_numberOfProcessors;		/**< number of onboard CPUs */
		};
	}
}
#endif	// End of SSystemInformation.hpp
